/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.tsd;

import com.ibm.hwmca.base.tsd.TransmitSvcDataUtils;
import com.ibm.hwmca.base.tsd.TsdEntryData;
import com.ibm.hwmca.base.tsd.TsdErrorIds;
import com.ibm.hwmca.base.tsd.TsdRetrieveDataException;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.rsf.RsfResultProcessor;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.TransmitDataRequestBody;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TsdSendData
implements RsfResultProcessor,
TsdErrorIds {
    private static final String TRACE_MASKT = "XTSDSNDT";
    private static final String TRACE_MASKF = "XTSDSNDF";
    private static final String TRACE_MASKD = "XTSDSNDD";
    public static final String TSAD_ATTRIBUTE = "TSAD";
    public ArrayList listOfFiles = new ArrayList();
    HashMap cleanupMethods = new HashMap();
    public boolean userInterfaceInitiated = true;
    private static ArrayList listOfRequests = new ArrayList();
    private static Object requestsLock = new Object();
    private static String className = "com.ibm.hwmca.base.tsd.TsdSendData";
    private static String utilClassName = "com.ibm.hwmca.base.tsd.TransmitSvcDataUtils";
    private static String tsadFileName = "acusevt.trm";
    private static String tsadProgramName = "logSummary";
    private static LocalizableText desc = new LocalizableText("Transmit service data to RETAIN");
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "TsdSendData");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;

    public static void sendInstallData(String installFilePathName) {
        if (!TsdSendData.isRemoteServiceConfigured("Transmit install data")) {
            return;
        }
        TsdSendData tsd = new TsdSendData();
        tsd.userInterfaceInitiated = false;
        TsdEntryData[] instData = new TsdEntryData[]{new TsdEntryData()};
        instData[0].setDataType((byte)0);
        instData[0].setMessageNumber((short)23);
        instData[0].setFileName(installFilePathName);
        try {
            tsd.send(instData, null);
        }
        catch (Exception e) {
            TsdSendData.logError("TsdSendData.sendInstallData: error sending data", e, (short)20592);
        }
    }

    public static void sendServiceAvailabilityData() {
        String filePath;
        if (!TsdSendData.isRemoteServiceConfigured("Transmit service availability data")) {
            return;
        }
        TsdSendData tsd = new TsdSendData();
        tsd.userInterfaceInitiated = false;
        TsdEntryData[] instData = new TsdEntryData[]{new TsdEntryData()};
        instData[0].setDataType((byte)2);
        instData[0].setMessageNumber((short)17);
        try {
            filePath = BaseFileControl.getFilePath(tsadFileName);
        }
        catch (HException e) {
            TsdSendData.logError("TsdSendData.sendServiceAvailabilityData: unable to get filepath for file " + tsadFileName, e, (short)20592);
            return;
        }
        instData[0].setTsdUtilObject(utilClassName);
        instData[0].setFileName(filePath + tsadFileName);
        instData[0].setProgramName(tsadProgramName);
        try {
            tsd.send(instData, null);
        }
        catch (Exception e) {
            TsdSendData.logError("TsdSendData.sendServiceAvailabilityData: error sending data", e, (short)20592);
        }
    }

    private static boolean isRemoteServiceConfigured(String applicationOrigin) {
        RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
        if (rsf == null) {
            TsdSendData.logInfo("TsdSendData: console RSF unavailable. Request = " + applicationOrigin + ".", null, (short)20600);
            return false;
        }
        if (!rsf.isCallHomeEnabled()) {
            TsdSendData.logInfo("TsdSendData: call home not enabled.  Request = " + applicationOrigin + ".", null, (short)20600);
            return false;
        }
        if (!rsf.isCallHomeServerAvailable()) {
            TsdSendData.logInfo("TsdSendData: no call home server configured. Request = " + applicationOrigin + ".", null, (short)20600);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void send(TsdEntryData[] entryData, String pmh) throws HException, TsdRetrieveDataException {
        Trace.trace(TRACE_MASKT, "-> TsdSendData.send()");
        if (entryData == null) {
            HException h = new HException("Tsd send: null entry data");
            TsdSendData.logError("TsdSendData.send(), null entry data", h, (short)20595);
            throw h;
        }
        String dataDirectory = null;
        String stagingDirectory = null;
        try {
            dataDirectory = BaseFileControl.getFilePath("*.trm");
            stagingDirectory = dataDirectory + "tsd";
            Trace.trace(TRACE_MASKD, "staging Dir = " + stagingDirectory);
        }
        catch (HException e) {
            TsdSendData.logError("TsdSendData.send: cannot find path for data directory (*.trm)", e, (short)20595);
            throw e;
        }
        TransmitSvcDataUtils.startTsdFileProcessing();
        Object object = TransmitSvcDataUtils.tsdFileLock;
        // MONITORENTER : object
        if (TransmitSvcDataUtils.tempDirCounter.increment() > 1) {
            Trace.trace(TRACE_MASKF, "TSD: send: Number of open TSD requests for the Tsd temp dir," + stagingDirectory + " > 1. " + "Number open=" + TransmitSvcDataUtils.tempDirCounter.getValue());
        }
        // MONITOREXIT : object
        File dir = new File(stagingDirectory);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                HException e = new HException("Tsd temp dir, " + stagingDirectory + " already exists, but is not a directory");
                TsdSendData.logError("TsdSendData.send: TSD temp dir, " + stagingDirectory + "already exists, but is not a directory", e, (short)20595);
                Object object2 = TransmitSvcDataUtils.tsdFileLock;
                // MONITORENTER : object2
                TransmitSvcDataUtils.tempDirCounter.decrement();
                // MONITOREXIT : object2
                TransmitSvcDataUtils.endTsdFileProcessing();
                throw e;
            }
            Trace.trace(TRACE_MASKF, "TSD: send: TSD temp dir, " + stagingDirectory + " already exists.");
        } else {
            dir.mkdir();
        }
        int numOfEntries = Array.getLength(entryData);
        Trace.trace(TRACE_MASKD, "num of entries = " + numOfEntries);
        int ix = 0;
        try {
            while (ix < numOfEntries) {
                TsdEntryData data = entryData[ix];
                this.getFileList(data, stagingDirectory);
                ++ix;
            }
        }
        catch (HException e) {
            Object object3 = TransmitSvcDataUtils.tsdFileLock;
            // MONITORENTER : object3
            if (TransmitSvcDataUtils.tempDirCounter.decrement() < 1) {
                TsdSendData.deleteAllFiles(stagingDirectory);
                new File(stagingDirectory).delete();
            }
            // MONITOREXIT : object3
            TransmitSvcDataUtils.endTsdFileProcessing();
            TsdSendData.logError("TsdSendData.send: error getting data for entry " + ix + ": " + entryData[ix], e, (short)20595);
            throw e;
        }
        Object object4 = TransmitSvcDataUtils.tsdFileLock;
        // MONITORENTER : object4
        if (TransmitSvcDataUtils.tempDirCounter.decrement() < 1) {
            TsdSendData.deleteAllFiles(stagingDirectory);
            new File(stagingDirectory).delete();
        }
        // MONITOREXIT : object4
        if (this.listOfFiles.isEmpty()) {
            TransmitSvcDataUtils.endTsdFileProcessing();
            TsdRetrieveDataException e = new TsdRetrieveDataException("Tsd file list is empty");
            TsdSendData.logError("TsdSendData.send file list is empty", e, (short)20595);
            throw e;
        }
        RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
        if (rsf == null) {
            TransmitSvcDataUtils.endTsdFileProcessing();
            HException h = new HException("console RSF unavailable");
            TsdSendData.logError("TsdSendData: console RSF unavailable", h, (short)20585);
            throw h;
        }
        Trace.trace(TRACE_MASKD, "TsdSendData: got RemoteSupport Facility");
        RsfRequest req = null;
        String reqId = null;
        try {
            TransmitDataRequestBody tsdRequestBody = this.buildTSDRequestBody();
            req = rsf.newRequestInstance(tsdRequestBody, className, desc);
            Trace.trace(TRACE_MASKD, "TsdSendData: got new request instance");
            reqId = req.getId();
            Object object5 = requestsLock;
            // MONITORENTER : object5
            listOfRequests.add(reqId);
            // MONITOREXIT : object5
            req.submit();
            Trace.trace(TRACE_MASKD, "TsdSendData: submitted request " + reqId);
        }
        catch (Exception e) {
            if (reqId != null) {
                Object object6 = requestsLock;
                // MONITORENTER : object6
                listOfRequests.remove(reqId);
                // MONITOREXIT : object6
            }
            TransmitSvcDataUtils.endTsdFileProcessing();
            String msg = req == null ? "Rsf newRequestInstance error: " : "Rsf request submission error for " + reqId + ": ";
            HException h = new HException(e);
            TsdSendData.logError(msg + h.getMessage(), h, (short)20585);
            throw h;
        }
        Trace.trace(TRACE_MASKT, "<- TsdSendData.send()");
    }

    public void getFileList(TsdEntryData entryData, String dir) throws TsdRetrieveDataException, HException {
        String fileName;
        Trace.trace(TRACE_MASKT, "-> TsdSendData.getFileList()");
        byte action = entryData.getDataType();
        String method = entryData.getProgramName();
        short messageNumber = entryData.getMessageNumber();
        String[] peFileInfo = new String[]{entryData.getFileName(), entryData.getPeFilePattern()};
        String listFileName = null;
        TransmitSvcDataUtils utilObject = entryData.getTsdUtilObject();
        if (messageNumber == 27 && utilObject != null) {
            utilObject.setPeData(peFileInfo);
            method = "peData";
        }
        Trace.trace(TRACE_MASKD, "action = " + action + ", program = " + method);
        if (action == 2 || action == 3 || action == 4 || action == 5) {
            this.executeMethodAndSave(utilObject, method, false);
        }
        if (action == 0 || action == 3 || action == 5) {
            try {
                fileName = entryData.getFileName();
                Trace.trace(TRACE_MASKD, "entryData fileName = [" + fileName + "]");
                this.listOfFiles.add(new File(fileName));
            }
            catch (Exception e) {
                HException h = new HException("Tsd transmit filename is null");
                TsdSendData.logError("TsdSendData.getFileList: transmit filename is null", h, (short)20595);
                throw h;
            }
        }
        if (action == 1 || action == 2 || action == 4) {
            BufferedReader in;
            try {
                listFileName = entryData.getFileName();
                TsdSendData.retrieveFile(listFileName, dir);
            }
            catch (TsdRetrieveDataException e) {
                TsdSendData.logError("TsdSendData.getFileList: error retrieving file '" + listFileName + "' in '" + dir + "'", e, (short)20595);
                throw e;
            }
            fileName = null;
            String filePath = null;
            String nameOnly = null;
            int index = 0;
            Trace.trace(TRACE_MASKD, "listFileName = [" + listFileName + "]");
            index = listFileName.lastIndexOf("/");
            nameOnly = index > 0 ? listFileName.substring(index + 1) : ((index = listFileName.lastIndexOf("\\")) > 0 ? listFileName.substring(index + 1) : listFileName);
            String localName = dir + "/" + nameOnly;
            Trace.trace(TRACE_MASKD, "localName = [" + localName + "]");
            File listFile = new File(localName);
            try {
                in = new BufferedReader(new FileReader(listFile));
            }
            catch (FileNotFoundException e) {
                TsdRetrieveDataException t = new TsdRetrieveDataException(e);
                TsdSendData.logError("TsdSendData.getFileList: multi-filelist file '" + localName + "' not found.", t, (short)20595);
                throw t;
            }
            do {
                try {
                    fileName = in.readLine();
                    Trace.trace(TRACE_MASKD, "input = [" + fileName + "]");
                    if (fileName == null || fileName.length() <= 1 || fileName.substring(0, 2).equals("/*")) continue;
                    index = fileName.lastIndexOf("/");
                    if (index > 0) {
                        Trace.trace(TRACE_MASKF, "filename= '" + fileName + "'");
                        this.listOfFiles.add(new File(fileName));
                        continue;
                    }
                    filePath = BaseFileControl.getFilePath(fileName);
                    Trace.trace(TRACE_MASKF, "path = '" + filePath + "' filename= '" + fileName + "'");
                    this.listOfFiles.add(new File(filePath + fileName));
                }
                catch (HException e) {
                    TsdSendData.logInfo("TsdSendData.getFileList: unable to get filepath for '" + fileName + "'. ", e, (short)20595);
                }
                catch (IOException e) {
                    TsdRetrieveDataException t = new TsdRetrieveDataException(e);
                    TsdSendData.logError("TsdSendData.getFileList: error reading multi-filelist file'" + localName + "'.", t, (short)20595);
                    throw t;
                }
            } while (fileName != null);
        }
    }

    public void executeMethodAndSave(TransmitSvcDataUtils utilObject, String methodName, boolean reset) throws TsdRetrieveDataException {
        String utilClassName = TsdSendData.executeTsdUtilMethod(utilObject, methodName, reset);
        ArrayList<String> utilObjectMethods = (ArrayList<String>)this.cleanupMethods.get(utilClassName);
        if (utilObjectMethods == null) {
            utilObjectMethods = new ArrayList<String>();
            this.cleanupMethods.put(utilClassName, utilObjectMethods);
        }
        utilObjectMethods.add(methodName);
    }

    public static String executeTsdUtilMethod(TransmitSvcDataUtils utilObject, String methodName, boolean reset) throws TsdRetrieveDataException {
        String utilClassName = "";
        Method utilMethod = null;
        if (utilObject != null && methodName != null) {
            utilObject.setReset(reset);
            Class<?> utilClass = utilObject.getClass();
            utilClassName = utilClass.getName();
            Trace.trace(TRACE_MASKF, "->TsdSendData::executeTsdUtilMethod [" + methodName + "] in [" + utilClassName + "]");
            try {
                utilMethod = utilClass.getMethod(methodName, null);
                utilMethod.invoke((Object)utilObject, null);
            }
            catch (Exception e) {
                String action = "execute";
                if (utilMethod == null) {
                    action = "find";
                }
                String msg = "Error trying to " + action + " method '" + methodName + "' in '" + utilClassName + "'.";
                TsdRetrieveDataException exc = new TsdRetrieveDataException(msg);
                TsdSendData.logError("TsdSendData.executeTsdUtilMethod(): " + msg, exc, (short)20594);
                throw exc;
            }
        } else {
            String msg = utilObject == null ? "TransmitSvcDataUtils object not found" : "No utility method name specified";
            TsdRetrieveDataException exc = new TsdRetrieveDataException(msg);
            TsdSendData.logError("TsdSendData.executeTsdUtilMethod(): " + msg, exc, (short)20594);
            throw exc;
        }
        Trace.trace(TRACE_MASKT, "<- TsdSendData::executeTsdUtilMethod()");
        return utilClassName;
    }

    public static long retrieveFile(String fqFileName, String dir) throws TsdRetrieveDataException {
        Trace.trace(TRACE_MASKT, "-> TsdSendData.retrieveFile() for " + fqFileName + " to " + dir);
        String fileName = null;
        long fileSize = 0L;
        int index = fqFileName.lastIndexOf("/");
        Trace.trace(TRACE_MASKD, "index =" + index);
        fileName = index > 0 ? fqFileName.substring(index + 1) : fqFileName;
        String localName = dir + "/" + fileName;
        Trace.trace(TRACE_MASKF, "local file to be created [" + localName + "]");
        try {
            FileUtilities.copy(fqFileName, localName);
            fileSize = new File(localName).length();
            Trace.trace(TRACE_MASKF, "fileSize = " + fileSize);
        }
        catch (IOException e) {
            TsdRetrieveDataException t = new TsdRetrieveDataException(e);
            TsdSendData.logError("TsdSendData.retrieveFile: error copying " + fqFileName + " to " + localName + ".", t, (short)20595);
            new File(localName).delete();
            throw t;
        }
        Trace.trace(TRACE_MASKT, "<- TsdSendData.retrieveFile()");
        return fileSize;
    }

    public static void deleteAllFiles(String dir) {
        Trace.trace(TRACE_MASKT, "-> deleteAllFiles(" + dir + ")");
        File[] deleteFiles = null;
        try {
            deleteFiles = new File(dir).listFiles();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "caught Exception ");
            Trace.trace(TRACE_MASKF, e);
        }
        if (deleteFiles != null) {
            String fileName = null;
            int numberOfFiles = deleteFiles.length;
            int ix = 0;
            while (ix < numberOfFiles) {
                try {
                    fileName = deleteFiles[ix].getName();
                    Trace.trace(TRACE_MASKF, "deleting file [" + dir + "/" + fileName + "]");
                    File file = new File(dir + "/" + fileName);
                    file.delete();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "TsdSendData.deleteAllFiles exception deleting " + fileName);
                    Trace.trace(TRACE_MASKF, e);
                }
                ++ix;
            }
        }
        Trace.trace(TRACE_MASKT, "<- deleteAllFiles(" + dir + ")");
    }

    public TransmitDataRequestBody buildTSDRequestBody() {
        int POH = 72;
        TransmitDataRequestBody data = new TransmitDataRequestBody();
        String pss = this.userInterfaceInitiated ? "0" : "1";
        data.putAttribute(TSAD_ATTRIBUTE, pss);
        data.initializeUpdateList();
        data.initializeCustomerContactInformation();
        data.initializeMachineInformation();
        data.setFileList(this.listOfFiles);
        data.setUserAttachement(this.cleanupMethods);
        return data;
    }

    public void rsfRequestCompleted(RsfRequest request, RsfResult result) {
        String reqId = request.getId();
        Trace.trace(TRACE_MASKT, "<> TransmitSvcUtils.rsfRequestCompleted for " + reqId + ": " + " Result = " + result.getStatusCode() + ", " + result.getStatusMessage() + ".");
        boolean satisfactoryCompletion = true;
        if (result.getStatusCode() != 1) {
            satisfactoryCompletion = false;
        }
        HashMap fileActionMethods = null;
        try {
            fileActionMethods = (HashMap)((XFrameRsfRequestBody)request.getBody()).getUserAttachment();
        }
        catch (Exception e) {
            TsdSendData.logError("TsdSendData.rsfRequestCompleted: error getting user attachment", e, (short)20595);
        }
        if (fileActionMethods != null) {
            ArrayList methods = null;
            TransmitSvcDataUtils tsdUtils = null;
            String utilClassName = null;
            String methodName = null;
            Iterator utilObjects = fileActionMethods.keySet().iterator();
            while (utilObjects.hasNext()) {
                utilClassName = (String)utilObjects.next();
                try {
                    tsdUtils = (TransmitSvcDataUtils)Class.forName(utilClassName).newInstance();
                }
                catch (Throwable e) {
                    TsdSendData.logInfo("TsdSendData: rsfRequestCompleted: error instantiating TsdUtils object: " + utilClassName, e, (short)20595);
                    continue;
                }
                tsdUtils.setReset(true);
                tsdUtils.setSatisfactoryCompletion(satisfactoryCompletion);
                tsdUtils.setRsfRequest(request);
                methods = (ArrayList)fileActionMethods.get(utilClassName);
                try {
                    int i = 0;
                    while (i < methods.size()) {
                        methodName = (String)methods.get(i);
                        TsdSendData.executeTsdUtilMethod(tsdUtils, methodName, true);
                        ++i;
                    }
                }
                catch (Throwable e) {
                    TsdSendData.logInfo("TsdSendData: rsfRequestCompleted: error executing TsdUtils method: " + methodName, e, (short)20595);
                }
            }
        }
        if (listOfRequests.contains(reqId)) {
            int remainingRequests = TransmitSvcDataUtils.endTsdFileProcessing();
            Trace.trace(TRACE_MASKT, "<- TsdSendData.rsfRequestCompleted. Outstanding tsd requests=" + remainingRequests);
        } else {
            Trace.trace(TRACE_MASKT, "<- TsdSendData::rsfRequestCompleted() for unknown request Id probably due to restart.");
        }
    }

    private static void logError(String msg, Throwable t, short errorId) {
        Trace.trace(TRACE_MASKF, msg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
        }
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, errorId, t) : new FrameworkLog(logInfo, errorId);
        errLog.add(msg);
        errLog.log();
    }

    private static void logInfo(String msg, Throwable t, short errorId) {
        Trace.trace(TRACE_MASKF, msg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
        }
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, errorId, t) : new FrameworkLog(logInfo, errorId);
        errLog.add(msg);
        errLog.log(infoLog);
    }
}

